// ------------------------------
// Imports and Configuration
// ------------------------------
require("dotenv").config();
const express = require("express");
const cors = require("cors");
const mongoose = require("mongoose");
const colors = require("colors"); // For colored console logs
const { connection } = require("./configs/db");

// Create express app
const app = express();

// ------------------------------
// Middleware
// ------------------------------
app.use(cors());
app.use(express.json());
app.use(express.text());

// ------------------------------
// Mongoose Configuration
// ------------------------------
mongoose.set("strictQuery", true);

// ------------------------------
// Routes Imports
// ------------------------------
const adminRouter = require("./routes/Admins.Route");
const studentRouter = require("./routes/Student.Route");
const tutorRouter = require("./routes/Tutor.Route");
const quizRouter = require("./routes/Quiz.Route");
const contentRouter = require("./routes/Content.Route");
const DoubtRouter = require("./routes/Doubt.Route");
const DashboardRouter = require("./routes/Dashboard.Route");

// ------------------------------
// Base Route
// ------------------------------
app.get("/", (req, res) => {
  res.send("Welcome to LMS Application! 😊✌️");
});

// ------------------------------
// API Routes
// ------------------------------
app.use("/admin", adminRouter);
app.use("/student", studentRouter);
app.use("/tutor", tutorRouter);
app.use("/quiz", quizRouter);
app.use("/content", contentRouter);
app.use("/doubt", DoubtRouter);
app.use("/dashboard", DashboardRouter);

// ------------------------------
// Start Server
// ------------------------------
const PORT = process.env.PORT || 8000;

app.listen(PORT, async () => {
  try {
    await connection;
    console.log(colors.green("✅ Connected to MongoDB successfully!"));
  } catch (error) {
    console.log(colors.red("❌ Unable to connect to MongoDB!"));
    console.error(colors.red(error.message));
  }
  console.log(colors.cyan(`🚀 Server running on http://localhost:${PORT}`));
});
